//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Reg
{
    //+----------------+
    private:
    //+----------------+
        string  h_value;
        uint    k_value;
    //+----------------+
    public:
    //+----------------+
        void Set(const uint arg1, const string arg2)
        {
            k_value = arg1;
            h_value = arg2;
        }
    //+----------------+
        uint Get_K(void)    { return k_value; }
    //+----------------+
        string Get_H(void)  { return h_value; }
    //+----------------+
};
//+----------------+
struct st_Data
{
    //+----------------+
    private:
    //+----------------+
        st_Reg Values[];
    //+----------------+
    public:
    //+----------------+
        bool Set(const st_Reg &arg)
        {
            if (ArrayResize(Values, Values.Size() + (Values.Size() == 0 ? 2 : 1)) == INVALID_HANDLE)
                return false;

            Values[Values.Size() - 1] = arg;

            return true;
        }
    //+----------------+
        st_Reg Get(const uint index)
        {
            for (uint c = 0; c < Values.Size(); c++)
                if (Values[c].Get_K() == index)
                    return Values[c];

            return Values[0];
        }
    //+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => [", X, "]")
//+------------------------------------------------------------------+
void OnStart(void)
{
    const string T = "possible loss of data due to type conversion";
    const uint   K[] = {2, 1, 4, 0, 7, 5, 3, 6};

    st_Data info;
    string H[];

    StringSplit(T, ' ', H);
    for (uint c = 0; c < H.Size(); c++)
    {
        st_Reg  reg;

        reg.Set(K[c], H[c]);
        info.Set(reg);
    }

    PrintX(info.Get(3).Get_H());
    PrintX(info.Get(13).Get_H());
}
//+------------------------------------------------------------------+